---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-Batch Detail（バッチ詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/ui/BatchPage.scala` 行30-424
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` 行28-48
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.19
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.19
- E-05: `docs/code-to-docs/画面遷移図.md` DStreamTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/streaming/batch/ | E-01 行32: WebUIPage("batch") | ○ |
| C-02 | idパラメータ（バッチ時刻）が必須 | E-01 行322: request.getParameter("id") | ○ |
| C-03 | listener.synchronizedでrender実行 | E-01 行321: streamingListener.synchronized | ○ |
| C-04 | バッチサマリー（Duration/Input/Scheduling/Processing/Total） | E-01 行342-373 | ○ |
| C-05 | Input Metadataテーブル表示 | E-01 行339-341, 行381-408 | ○ |
| C-06 | ジョブテーブルの9列構成 | E-01 行36-49: columns定義 | ○ |
| C-07 | Output Operation別にジョブを表示 | E-01 行289-319: generateJobTable | ○ |
| C-08 | rowspanで出力操作情報をまとめ表示 | E-01 行121-129: rowspan使用 | ○ |
| C-09 | Job IDリンクがジョブ詳細へ遷移 | E-01 行113-114: detailUrl | ○ |
| C-10 | ジョブデータ破棄時の"-"表示 | E-01 行166-201: generateDroppedJobRow | ○ |
| C-11 | Sparkジョブなしの出力操作 | E-01 行68-88: generateOutputOpRowWithoutSparkJobs | ○ |
| C-12 | Output Operation+details展開 | E-01 行243-255: generateOutputOpDescription | ○ |
| C-13 | タスク進捗バー | E-01 行148-156: UIUtils.makeProgressBar | ○ |
| C-14 | ステージ失敗理由の表示 | E-01 行108-111: lastFailureReason | ○ |
| C-15 | バッチ不存在時のエラー | E-01 行330: IllegalArgumentException | ○ |
| C-16 | idパラメータ未指定時のエラー | E-01 行323-325: IllegalArgumentException | ○ |
| C-17 | HTMLエスケープ処理 | E-01 行406: StringEscapeUtils.escapeHtml4 | ○ |
| C-18 | ページタイトル形式 | E-01 行378: "Details of batch at $formattedBatchTime" | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] ジョブデータ破棄（sparkListener保持上限超過）時の表示が適切か実機確認
- [ ] Output Operationのfailure表示がUI用メッセージ変換で正しいか確認
